/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.integrator.adaptors.jms;

import java.util.Hashtable;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueReceiver;
import javax.jms.QueueSession;
import javax.jms.TextMessage;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class QueueReceive
implements MessageListener {
    public static final String JNDI_FACTORY = "com.ibm.websphere.naming.WsnInitialContextFactory";
    private QueueConnectionFactory qconFactory;
    private QueueConnection qcon;
    private QueueSession qsession;
    private QueueReceiver qreceiver;
    private Queue queue;
    private boolean quit = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message msg) {
        block5: {
            try {
                String msgText = msg instanceof TextMessage ? ((TextMessage)msg).getText() : msg.toString();
                System.out.println("Message Received:");
                System.out.println(msgText);
                if (!msgText.equalsIgnoreCase("quit")) break block5;
                QueueReceive queueReceive = this;
                synchronized (queueReceive) {
                    this.quit = true;
                    this.notifyAll();
                }
            }
            catch (JMSException jmse) {
                jmse.printStackTrace();
            }
        }
    }

    public void init(Context ctx, String QCF, String queueName) throws NamingException, JMSException {
        this.qconFactory = (QueueConnectionFactory)ctx.lookup(QCF);
        this.qcon = this.qconFactory.createQueueConnection();
        this.qsession = this.qcon.createQueueSession(false, 1);
        this.queue = (Queue)ctx.lookup(queueName);
        this.qreceiver = this.qsession.createReceiver(this.queue);
        this.qreceiver.setMessageListener((MessageListener)this);
        this.qcon.start();
    }

    public void close() throws JMSException {
        this.qreceiver.close();
        this.qsession.close();
        this.qcon.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        int i = 0;
        String host = "localhost";
        String port = "2809";
        String JMS_QCF = "QConnectionFactoryJNDI";
        String JMS_QUEUE = "QQueueJNDI";
        while (i < args.length && args[i].startsWith("-")) {
            String arg;
            if ((arg = args[i++]).equals("-host")) {
                if (i < args.length) {
                    host = args[i++];
                    continue;
                }
                System.err.println("-host requires a hostname");
                continue;
            }
            if (arg.equals("-port")) {
                if (i < args.length) {
                    port = args[i++];
                    continue;
                }
                System.err.println("-port requires a portnumber");
                continue;
            }
            if (arg.equals("-qcf")) {
                if (i < args.length) {
                    JMS_QCF = args[i++];
                    continue;
                }
                System.err.println("-qcf requires a Queue Connection Factory JNDI name");
                continue;
            }
            if (!arg.equals("-queue")) continue;
            if (i < args.length) {
                JMS_QUEUE = args[i++];
                continue;
            }
            System.err.println("-queue requires a queue JNDI name");
        }
        if (i != args.length) {
            System.err.println("Usage: QueueReceive [-host hostname] [-port portnumber] -qcf queue connection factory -queue queue\n");
            System.err.println("\tDefault hostname is localhost");
            System.err.println("\tDefault portnumber is 2809");
            System.err.println("\tDefault queue ocnnection factory is 'QConnectionFactoryJNDI'");
            System.err.println("\tDefault queue is 'QQueueJNDI'");
            return;
        }
        String url = "iiop://" + host + ":" + port;
        InitialContext ic = QueueReceive.getInitialContext(url);
        QueueReceive qr = new QueueReceive();
        qr.init(ic, JMS_QCF, JMS_QUEUE);
        System.out.println("Ready To Receive Messages from " + url + ".");
        System.out.println("(To quit, send a \"quit\" message).\n");
        QueueReceive queueReceive = qr;
        synchronized (queueReceive) {
            while (!qr.quit) {
                try {
                    qr.wait();
                }
                catch (InterruptedException ie) {}
            }
        }
        qr.close();
    }

    private static InitialContext getInitialContext(String url) throws NamingException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", JNDI_FACTORY);
        env.put("java.naming.provider.url", url);
        return new InitialContext(env);
    }
}

